#!/usr/bin/env bash

echo "" > git-trace.txt

rm data.txt.asc dbgmd-00001.sign dbgmd-00001.verify dbgmd-00002.unknown \
  bad-dbgmd-00001.sign bad-dbgmd-00001.verify bad-dbgmd-00002.unknown \
  good-dbgmd-00001.sign good-dbgmd-00001.verify good-dbgmd-00002.unknown

for i in {1..100}; do
  echo "loop ${i}"
  rm data.txt.asc
  echo "data was"
  echo "$(cat data.txt)"
  gpg --verbose --debug hashing -bsau 6E628CC4145FD2ED data.txt
  echo ""
  echo "signature was"
  echo "$(cat data.txt.asc)"
  echo ""
  echo "verification was"
  if ! gpg --verify --verbose --debug hashing data.txt.asc data.txt; then
    echo "result: failed"
    echo "gpg verify failed for ${i}"
    mv dbgmd-00001.sign bad-dbgmd-00001.sign
    mv dbgmd-00001.verify bad-dbgmd-00001.verify
    mv dbgmd-00002.unknown bad-dbgmd-00002.unknown
    break;
  else
    echo "result: succeeded"
    echo "gpg verify passed for ${i}"
    mv dbgmd-00001.sign good-dbgmd-00001.sign
    mv dbgmd-00001.verify good-dbgmd-00001.verify
    mv dbgmd-00002.unknown good-dbgmd-00002.unknown
  fi
  echo ""
  echo ""
done
